import NextImg from "@/src/components/NextImage";
import { useCategoriesQuery } from "@/src/hooks/Queries";
import { ArrowDown2 } from "iconsax-react";
import React, { useState } from "react";

interface Props {
  onChangeCategories: (category: string) => void;
  defaultCategory?: string;
  showDiscount: boolean;

  onDiscountSwitch: (value: boolean) => void;
}
function FoodsSideBar({
  onChangeCategories,
  defaultCategory,
  onDiscountSwitch,
  showDiscount,
}: Props) {
  const { data: categories } = useCategoriesQuery({});
  const [menuCollapse, setMenuCollapse] = useState(true);
  return (
    <div className="flex h-max w-full flex-col rounded-half bg-primary p-2 text-white shadow-base  lg:max-w-xs  lg:shadow-4">
      <button
        className="flex w-full  justify-between py-2 text-h3 font-bold"
        onClick={() => setMenuCollapse(!menuCollapse)}
      >
        دسته بندی های غذایی
        <span className=" rounded-full bg-secondary p-[4px]">
          <ArrowDown2
            size="16"
            variant="Broken"
            className={`   duration-700 ${menuCollapse && "rotate-180"}`}
          />
        </span>
      </button>

      <div
        className={`flex overflow-auto  transition-max-height duration-700 ease-in-out ${
          menuCollapse ? "max-h-[600px]  " : "max-h-0"
        } border-stroke-primary   flex-col border-b  `}
      >
        <button
          onClick={() => onChangeCategories("")}
          className={`mb-2 w-full px-2 text-right text-h4 ${
            !defaultCategory && "font-bold"
          }`}
        >
          همه دسته بندی ها
        </button>{" "}
        {categories?.map((item) => (
          <button
            key={item.id}
            onClick={() => onChangeCategories(item.id)}
            className={`mb-2 flex w-full gap-1 px-2  text-right text-h4 ${
              item.id === defaultCategory && "font-bold"
            }`}
          >
            <NextImg src={item.image} alt={item.title} width={22} height={22} />
            {item.title}
          </button>
        ))}
      </div>
      <div className="border-stroke-primary flex items-center justify-between border-b py-2">
        <p className="text-h4 font-bold">تخفیف دارها</p>
        <label className="relative inline-flex cursor-pointer items-center">
          <input
            type="checkbox"
            value=""
            checked={showDiscount}
            onChange={(e) => onDiscountSwitch(e.target.checked)}
            className="peer sr-only"
          />
          <div
            className=" 
         peer-checked:bg-Success-primary peer  h-4 w-7
        rounded-full border border-gray-500 bg-primary after:absolute
         after:end-[2px] after:start-[2px] after:top-[4px] after:size-3 after:rounded-full after:border
          after:border-gray-300 after:bg-white after:transition-all after:content-[''] peer-checked:after:translate-x-full
           peer-checked:after:border-white peer-focus:outline-none rtl:peer-checked:after:-translate-x-full
            "
          ></div>
        </label>
      </div>
    </div>
  );
}

export default FoodsSideBar;
