import { BaseChef } from "@/src/types/Chef";
import React from "react";
import { Navigation } from "swiper/modules";
import { Swiper, SwiperSlide } from "swiper/react";
import Link from "next/link";
import { ArrowLeft2 } from "iconsax-react";
import BestChefCard from "../BestChefCart";

interface Props {
  chefs: BaseChef[];
  title: string;
  buttonText?: string;
  link?: string;
}

function ChefSlider({ chefs, buttonText, title, link }: Props) {
  return (
    <div className="  relative w-full  ">
      <div className="mb-12 flex w-full items-center justify-between text-body font-bold  lg:text-h2">
        {title}
        <Link
          className="relative flex items-center gap-4 text-h5 text-primary lg:text-body"
          href={link ?? "/chefs?page=1&orderBy=rate"}
        >
          {buttonText ?? "مشاهده بیشتر"}
          <ArrowLeft2 size="12" className="text-primary" />
        </Link>
      </div>
      <Swiper
        navigation={true}
        modules={[Navigation]}
        className="h-[225px] w-full"
        spaceBetween={20}
        // loop

        breakpoints={{
          240: {
            slidesPerView: 1.2,
            spaceBetween: 10,
          },

          540: {
            slidesPerView: 3,
            spaceBetween: 10,
          },
          670: {
            slidesPerView: 4,
            spaceBetween: 24,
          },
          890: {
            slidesPerView: 4,
          },
          1280: {
            slidesPerView: 4,
          },
        }}
      >
        {chefs.map((item) => (
          <SwiperSlide key={item.id}>
            <Link href={`/chef/${item.id}`}>
              <BestChefCard
                cover={item.cover ?? ""}
                ariaTitle={item.ariaTitle ?? ""}
                logo={item.logo ?? ""}
                rate={item.rate ?? 0}
                title={item.title}
              />
            </Link>
          </SwiperSlide>
        ))}
      </Swiper>
    </div>
  );
}

export default ChefSlider;
