"use client"

import React, { useEffect, useState } from "react";

import { useCategoriesQuery } from "@/src/hooks/Queries";
import NextImg from "@/src/components/NextImage";
import Link from "next/link";
import { Swiper, SwiperSlide } from "swiper/react";
import { twMerge } from "tailwind-merge";

interface Props {
  wrapperClassName?: string;
  parentID?: string;
}

function CategorySlider({ wrapperClassName, parentID }: Props) {
  const [lat, setLat] = useState<string | null>(null);
  const [lng, setLng] = useState<string | null>(null);

  useEffect(() => {
    if (typeof window !== "undefined") {
      const unsavedAddress = localStorage.getItem("unsavedAddress");
      if (unsavedAddress) {
        try {
          const addressData = JSON.parse(unsavedAddress);
          setLat(addressData.lat || null);
          setLng(addressData.lng || null);
        } catch (error) {
          console.error("Error parsing unsavedAddress:", error);
        }
      }
    }
  }, []);

  // Only include lat/lng in query if they exist
  const { data } = useCategoriesQuery({
    parentID,
    ...(lat ? { lat } : {}),
    ...(lng ? { lng } : {})
  });

  return (
    <div className={twMerge("w-full", wrapperClassName)}>
      {data && (
        <Swiper
          spaceBetween={16}
          breakpoints={{
            240: {
              slidesPerView: 3,
              spaceBetween: 16,
            },
            400: {
              slidesPerView: 3.5,
            },
            540: {
              slidesPerView: 6,
            },
            670: {
              slidesPerView: 8,
            },
            900: {
              slidesPerView: 10,
              spaceBetween: 16,
            },
          }}
          className=" w-full"
        >
          {data?.map((item) => (
            <SwiperSlide key={item.id} className="max-w-fit">
              <Link
                href={`/chefs?category=${item.id}`}
                key={item.id}
                className="flex size-50   flex-col items-center justify-center rounded-half  border  border-black/20 p-4 transition-all hover:border-primary hover:bg-error-extraLight"
              >
                <NextImg
                  src={item.image}
                  alt={item.title}
                  width={56}
                  height={56}
                />
                <span className="max-w-full truncate text-center text-h4">
                  {item.title}
                </span>
              </Link>
            </SwiperSlide>
          ))}{" "}
        </Swiper>
      )}
    </div>
  );
}

export default CategorySlider;
