import React from "react";
import { PaginationResult } from "@/src/types/general";
import { useCart } from "@/src/hooks";

import ProductCard from "@/src/components/ProductCard";
import { FoodMenu } from "@/src/types/food";
import { Swiper, SwiperSlide } from "swiper/react";
import { Grid } from "swiper/modules";

import "swiper/css/grid";
import { useRouter } from "next/navigation";

interface Props {
  data: PaginationResult<FoodMenu>;
}

function OfferSlider({ data }: Props) {
  const { handleAddCard, handleRemoveCard } = useCart();
  const router = useRouter();

  return (
    <div className="h-[350px] w-full max-w-full">
      {data && (
        <Swiper
          modules={[Grid]}
          grid={{
            rows: 2,
            fill: "column",
          }}
          breakpoints={{
            240: {
              slidesPerView: 1.2,
            },

            540: {
              slidesPerView: 2,
            },
            670: {
              slidesPerView: 3,
            },
          }}
          spaceBetween={10}
          className="size-full"
        >
          {data?.data.map((product) => (
            <SwiperSlide key={product.id}>
              <ProductCard
                isLoadingCart
                className="w-full"
                onSelect={() =>
                  router.push(`/chef/${product.chefID}#menu_discount`)
                }
                titleClassName=" xl:max-w-[160px] 2xl:max-w-[200px]"
                onAddCard={(variety) => handleAddCard(product, variety)}
                onRemoveCard={(variety) => handleRemoveCard(variety)}
                key={product.id}
                Summary={product.Summary}
                image={product.image}
                title={product.title}
                available={false}
                varieties={product.varieties.slice(0, 1)}
              />
            </SwiperSlide>
          ))}{" "}
        </Swiper>
      )}
    </div>
  );
}

export default OfferSlider;
