import Image from "next/image";
import React from "react";
import line from "@/public/assets/images/icons/line.svg";
import { Variants, motion } from "framer-motion";

interface Props {
  items: {
    image: string;
    title: string;
  }[];
}
const cardVariants: Variants = {
  offscreen: {
    y: 300,
  },
  onscreen: {
    y: 0,

    transition: {
      ease: "easeInOut",

      duration: 1.25,
    },
  },
};
function RoadMap({ items }: Props) {
  return (
    <motion.div
      initial="offscreen"
      whileInView="onscreen"
      viewport={{ once: true, amount: 0.2 }}
      className="container relative mb-2 grid w-full grid-cols-2 gap-7  lg:grid-cols-4"
    >
      {items.map((item, index) => (
        <motion.div
          className="z-20 flex items-center justify-center gap-1"
          variants={cardVariants}
          key={item.image}
        >
          <Image src={item.image} width={200} height={200} alt="sss" />
          {index < items.length - 1 && (
            <Image
              className="  hidden 2xl:block  "
              src={line}
              width={120}
              height={50}
              alt="sss"
            />
          )}
        </motion.div>
      ))}{" "}
    </motion.div>
  );
}

export default RoadMap;
