"use client";

import Drawer from "@/src/components/Drawer/DrawerShowAddress";
import { Modal } from "@/src/components/Modal";
import { useAuth } from "@/src/hooks";
import { useOrderAddressQuery } from "@/src/hooks/Queries";
import React, { useEffect, useState } from "react";
import AddressPrimary from "../../Profile/profileTabs/Address/AddressPrimary";
import { usePathname } from "next/navigation";
import pointer from "@/public/assets/images/icons/pointer.svg";
import Image from "next/image";

``;
function DrawerAddress() {
  const [showAddAddress, setShowAddAddressModal] = useState(false);
  const [showDrawer, setShowDrawer] = useState(false);
  const { refetch } = useOrderAddressQuery();
  const pathname = usePathname();
  const { getTokenFromCookies } = useAuth();
  const token = getTokenFromCookies();

  // Determine if it's a chef page
  const isChefPage = pathname?.startsWith("/chef");

  useEffect(() => {
    if (isChefPage) return;

    const unsavedAddress = localStorage.getItem("unsavedAddress");
    if (!token && !unsavedAddress) {
      setShowDrawer(true);
    }
  }, [token, isChefPage]);

  const addAddress = () => {
    if (isChefPage) return;

    const unsavedAddress = localStorage.getItem("unsavedAddress");
    if (!token && !unsavedAddress) {
      setShowAddAddressModal(true);
      setShowDrawer(false);
    }
  };

  if (isChefPage) {
    return null;
  }

  return (
    <div>
      <Drawer
        isOpenDrawer={showDrawer}
        headerTitle="انتخاب موقعیت مکانی"
        position="bottom"
      >
        <div className="flex justify-center">
          <Image
            src={pointer}
            width={76}
            height={30}
            alt="marker"
            className="pointer-events-none z-20"
          />
        </div>

        <p className="px-24 text-text-secondary text-center my-12">
          برای دیدن فروشگاه های اطراف خود، آدرس خود را وارد کنید.
        </p>
        <div className="mt-8 flex items-center mb-6 justify-center">
          <button
            onClick={() => setShowDrawer(false)}
            className="border-1 w-full ml-6 flex size-max items-center justify-center rounded-half border bg-transparent px-12 py-5 leading-6 text-black disabled:bg-gray-800 lg:px-16"
          >
            بعدا
          </button>
          <button
            onClick={addAddress}
            className="flex size-max w-full items-center justify-center rounded-half bg-primary px-12 py-5 leading-6 text-white disabled:bg-gray-800 lg:px-16"
          >
            فعال سازی
          </button>
        </div>
      </Drawer>
      <Modal
        title="افزودن آدرس"
        onClose={() => setShowAddAddressModal(false)}
        open={showAddAddress}
      >
        <AddressPrimary
          onAddAddress={() => {
            refetch();
            setShowAddAddressModal(false);
          }}
        />
      </Modal>
    </div>
  );
}

export default DrawerAddress;
