import React from "react";
import { useSettingsStore } from "@/src/providers/SettingsProvider";
import { Logo } from "@/src/components/Logo";
import { ApiPageItem } from "@/src/services/httpServices/SettingsServices/types";
import enamad from "@/public/assets/images/icons/enamad.png";
import Link from "next/link";
import Image from "next/image";
import SocialMedia from "./SocialMedia";
import DrawerAddress from "./DrawerAddress";

interface Props {
  pages: ApiPageItem[];
}
function Footer({ pages }: Props) {
  const settings = useSettingsStore((state) => state.settings);   
  return (
    <footer className=" w-full  bg-white shadow-4 ">
      <div className=" bg-black/5">
        <div className="container flex w-full items-center justify-between py-6 lg:py-12">
          <Logo height={20} width={116} />
          <p className="text-h5 lg:text-h3">
            {settings.headerTextSupport}: {settings.headerTelephoneSupport}
          </p>
        </div>
      </div>
      <div className="container ">
        <div className="flex items-center justify-between py-12">
          <ul className="grid w-full  grid-cols-2  gap-y-8 lg:grid-cols-4 lg:gap-x-20">
            {pages.map((item) => (
              <li key={item.slug}>
                <Link className="w-full text-body" href={`/pages/${item.slug}`}>
                  {item.title}
                </Link>
              </li>
            ))}{" "}
          </ul>
          {settings.enamadCode && (
            <div className="flex size-40 items-center justify-center rounded-2 bg-white lg:size-40">
              <Link
                href={settings.enamadCode}
                prefetch={false}
                target="_blank"
                referrerPolicy="origin"
              >
                <Image src={enamad} width={80} height={80} alt="enamd" />
              </Link>
            </div>
          )}
        </div>
      </div>
      <div className=" hidden border-t border-black/20 lg:block">
        <div className="container flex w-full items-center justify-between py-4">
          <p className="text-h4  ">
            کلیه حقوق این سایت متعلق به {settings.title} می باشد.
          </p>
          <SocialMedia
            instagram={settings.instagram}
            whatsApp={settings.whatsapp}
          />
        </div>
      </div>
          {settings.mode === 'multiVendor' ? <DrawerAddress/> : '' }
    </footer>
  );
}

export default Footer;
