import { FormProvider } from "@/src/components/RHF";
import { useSettingsStore } from "@/src/providers/SettingsProvider";
import { SearchNormal1 } from "iconsax-react";
import { useRouter } from "next/navigation";

import React from "react";
import { useForm } from "react-hook-form";
import { useTranslation } from "react-i18next";

interface FormFields {
  text: string;
}

function SearchBar() {
  const methods = useForm<FormFields>({
    defaultValues: {
      text: "",
    },
  });
  const router = useRouter();
  const { mode } = useSettingsStore((state) => state.settings);

  const { handleSubmit, reset, register } = methods;
  const onSubmit = handleSubmit(async (values) => {
    let lat: string | undefined;
    let lng: string | undefined;
    const unsavedAddress = localStorage.getItem("unsavedAddress");
    if (unsavedAddress) {
      try {
        const addressData = JSON.parse(unsavedAddress);
        lat = addressData.lat;
        lng = addressData.lng;
      } catch (error) {
        console.error("Error parsing unsavedAddress:", error);
      }
    }

    const params = new URLSearchParams();
    params.append("search", values.text);
    if (lat) {
      params.append("lat", lat);
    }
    if (lng) {
      params.append("lng", lng);
    }

    const path =
      mode === "multiVendor"
        ? `/${process.env.NEXT_PUBLIC_SEARCH_ADDRESS}?${params.toString()}`
        : `/?${params.toString()}`;

    reset();
    router.push(path);
  });
  const { t } = useTranslation();

  const searchKey =
    process.env.NEXT_PUBLIC_SEARCH_ADDRESS === "products"
      ? "search_placeholder_single"
      : "search_placeholder";

  const placeholder = mode === "single" ? t("search_placeholder_single") : t(searchKey);

  return (
    <FormProvider methods={methods} onSubmit={onSubmit}>
      <div className="flex min-w-[390px] items-center gap-2 overflow-hidden rounded-half border bg-black/5 px-4 py-6">
        <SearchNormal1 size="24" className="text-primary" variant="Broken" />
        <input
          {...register("text")}
          type="text"
          className="size-full bg-transparent text-h3 text-primary outline-none"
          placeholder={placeholder}
          onKeyDown={(e) => {
            if (e.key === "Enter") {
              e.preventDefault();
              onSubmit();
            }
          }}
        />
      </div>
    </FormProvider>
  );
}

export default SearchBar;
