import { mobileMenuItem } from "@/src/constants/MenuItems";
import { useSettingsStore } from "@/src/providers/SettingsProvider";

import { type Icon as Ictype } from "iconsax-react";

import Link from "next/link";
import { usePathname, useSearchParams } from "next/navigation";

import React, { useMemo } from "react";
import { useTranslation } from "react-i18next";

function MobileNav() {
  const pathname = usePathname();
  const searchparams = useSearchParams();

  const { mode } = useSettingsStore((state) => state.settings);
  const filteredMenuItems = useMemo(
    () =>
      mobileMenuItem.filter((item) =>
        mode === "single" ? !item.multiVendorExclusive : item
      ),
    [mode]
  );
  const { t } = useTranslation();

  return (
    <div className="sticky bottom-0 left-0 z-50 flex flex-col items-end gap-8  lg:hidden">
      <div className="block h-30 w-full border-t border-black/40 bg-white  lg:hidden">
        <div
          className={`mx-auto grid h-full  max-w-lg ${mode === "single" ? "grid-cols-3" : "grid-cols-4"}`}
        >
          {filteredMenuItems.map((item, index) => {
            const Icon = item.icon as Ictype;
            const menuActive =
              `${pathname}${searchparams.toString() ? `?${searchparams.toString()}` : ""}` ===
              item.link;

            return (
              <Link
                href={item.link}
                key={index}
                className={`group inline-flex flex-col items-center justify-center gap-3 font-medium ${
                  menuActive ? "text-secondary " : "text-black"
                } `}
              >
                {item.icon && (
                  <Icon variant={menuActive ? "Bulk" : "Outline"} />
                )}
                <span className="text-h5 ">{t(item.title)}</span>
              </Link>
            );
          })}
        </div>
      </div>
    </div>
  );
}

export default MobileNav;
