"use client";

import React, { ReactNode, useMemo } from "react";

import {
  noHeaderRouts,
  noFooterRouts,
  noMobileHeaderRouts,
  noMobileFooterRouts,
} from "@/src/configs";
import { usePathname } from "next/navigation";
import { useSettingsStore } from "@/src/providers/SettingsProvider";
import { ApiPageItem } from "@/src/services/httpServices/SettingsServices/types";

import Link from "next/link";
import UseCartStore from "@/src/store/UseCartStore";
import MobileHeader from "./MobileHeader";
import Header from "./Header";
import Footer from "./Footer";
import MobileNav from "./MobileNav";

interface Props {
  children: ReactNode;
  pages: ApiPageItem[];
}

function LayoutProvider({ children, pages }: Props) {
  const path = usePathname();
  const settings = useSettingsStore((state) => state.settings);
  const homePageSingle = useMemo(
    () => settings.mode === "single" && path === "/",
    [path, settings.mode]
  );
  const { cardItems } = UseCartStore();
  return (
    <>
      {!noHeaderRouts.find(
        (route) => path === route || path.startsWith(route)
      ) &&
        !homePageSingle && (
          <>
            <div className="hidden lg:block"><Header /></div>
          </>
        )}
      {!noMobileHeaderRouts.find(
        (route) => path === route || path.startsWith(route)
      ) && (
        <>
          <div className="lg:hidden"><MobileHeader /></div>
        </>
      )}
      <main className="  relative min-h-screen bg-white">{children}</main>
      {!!cardItems.length && path !== "/cart" && !path.startsWith("/auth") && (
        <div className="fixed bottom-40 left-12 z-50 lg:bottom-12">
          <Link
            href="/cart"
            className="    w-max rounded-half border-black/20 bg-primary p-4 text-h5 font-bold  text-white  "
          >
            تکمیل سفارش ({cardItems.length ?? 0})
          </Link>
        </div>
      )}
      {!noFooterRouts.find(
        (route) => path === route || path.startsWith(route)
      ) && (
        <>
          <Footer pages={pages} />
        </>
      )}
      {!noMobileFooterRouts.find(
        (route) => path === route || path.startsWith(route)
      ) && (
        <>
          <MobileNav />
        </>
      )}
    </>
  );
}

export default LayoutProvider;
