import React from "react";

import Link from "next/link";
import NextImg from "@/src/components/NextImage";
import emptyImage from "@/public/assets/images/default/no-order.svg";

import ChefLoader from "@/src/containers/Chefs/ChefLoader";

import { Post } from "@/src/types/Post";
import ChefOrder from "../ChefOrder";

interface Props {
  posts: Post[] | [];
  isLoading: boolean;
  onChangeCategories: (category: string) => void;
  defaultCategory?: string;
}
function ChefsItems({
  posts,
  onChangeCategories,
  defaultCategory,
  isLoading,
}: Props) {
  return (
    <div className="flex min-h-[600px] w-full ">
      <div className="flex w-full gap-8">
        <div className="hidden w-full max-w-xs lg:block">
          <ChefOrder
            onChangeCategories={onChangeCategories}
            defaultCategory={defaultCategory}
          />
        </div>

        <div className="grid h-fit w-full grid-cols-1 gap-x-8 gap-y-16  lg:grid-cols-4 ">
          {isLoading && <ChefLoader />}
          {posts.map((post) => (
            <Link href={`/post/${post.id}`} key={post.id}>
              <div className="flex flex-col items-center justify-center gap-4 border  border-black/10 ">
                <div className=" flex w-full cursor-pointer  flex-col items-center gap-4">
                  <NextImg
                    src={post.cover}
                    width={250}
                    height={170}
                    alt={post.title}
                  />
                  <p className=" w-full max-w-full truncate p-4   text-h5 font-bold">
                    {post.title}
                  </p>
                  <p className=" w-full max-w-full truncate p-4   text-h5 text-black/70">
                    {post.category.title}
                  </p>
                </div>
              </div>
            </Link>
          ))}{" "}
          {!isLoading && !posts.length && (
            <div className="col-span-3 flex w-full flex-col items-center justify-center gap-12 py-16 ">
              <NextImg
                src={emptyImage}
                alt="no-address"
                width={115}
                height={140}
              />
              <p className="text-h3 ">مقاله ای یافت نشد</p>
            </div>
          )}
        </div>
      </div>
    </div>
  );
}

export default ChefsItems;
