import { ArrowRight2 } from "iconsax-react";
import React from "react";
import { useRouter } from "next/navigation";
import { useMediaQuery } from "@uidotdev/usehooks";
import ProductActions from "../ProductActions";

interface Props {
  productTitle: string;
  onShare: VoidFunction;
  onFavorite: VoidFunction;
  isLiked: boolean;
}

function MobileHeader({ isLiked, productTitle, onFavorite, onShare }: Props) {
  const router = useRouter();
  const isDesktop = useMediaQuery("only screen and (min-width: 1024px)");

  return !isDesktop ? (
    <div className="flex items-center justify-between gap-2 bg-primary py-2 text-h3  font-bold text-white lg:hidden">
      <button
        onClick={() => router.back()}
        className="flex   items-center gap-2"
      >
        <ArrowRight2 variant="Broken" />

        <span className=" w-3/4 truncate">{productTitle}</span>
      </button>
      <ProductActions
        isLiked={isLiked}
        onFavorite={onFavorite}
        onShare={onShare}
      />
    </div>
  ) : (
    <></>
  );
}

export default MobileHeader;
