import Image from "next/image";
import React from "react";
import { Material } from "@/src/types/food";

function ProductItemCard({ image, title, unit, usage }: Material) {
  return (
    <div className="flex gap-1 rounded-base bg-card  p-1">
      <Image alt="icon" src={image} width={58} height={58} />
      <div className="text-black">
        <p className="text-body">{title}</p>
        <p className="text-h-4 mt-1 text-gray-800">
          {usage} {unit}
        </p>
      </div>
    </div>
  );
}

export default ProductItemCard;
