import React from "react";
import { ClassNameValue, twMerge } from "tailwind-merge";

function generateStrokeDashoffset(percentInput: number) {
  const percent = (Math.min(100, Math.max(0, percentInput)) * 62) / 100;

  return percent;
}

interface Props {
  className: ClassNameValue;
  percent?: number;
  title: string;
  value: number;
}

function ProductNutritionalValueCard({
  title,
  className,
  percent = 0,
  value,
}: Props) {
  return (
    <div className="flex w-full items-center gap-1  rounded-5 bg-primary p-1 lg:max-w-[200px]">
      <div className="relative size-7">
        <svg className="h-full w-full" viewBox="0 0 100 100">
          <circle
            className="stroke-current text-gray-300"
            strokeWidth="3"
            cx="50"
            cy="50"
            r="40"
            fill="transparent"
          ></circle>

          <circle
            className={twMerge(
              "progress-ring__circle stroke-current text-warning-light",
              className
            )}
            strokeWidth="5"
            strokeLinecap="round"
            cx="50"
            cy="50"
            r="40"
            fill="transparent"
            strokeDashoffset={`calc(400 - (400 * ${generateStrokeDashoffset(
              percent
            )}) / 100)`}
          ></circle>

          <text
            x="50"
            y="50"
            textAnchor="middle"
            fill="#AAAAAA"
            alignmentBaseline="middle"
            fontSize="16"
          >
            {percent}%
          </text>
        </svg>
      </div>

      <div>
        <p className="text-h5 font-bold">{title}</p>
        <p className="mt-1 text-h5">{value} kc </p>
      </div>
    </div>
  );
}

export default ProductNutritionalValueCard;
