import Button from "@/src/components/Button";
import { AddressForm } from "@/src/types/Address";

import dynamic from "next/dynamic";
import React from "react";
import { useFormContext } from "react-hook-form";

const NeshanMapContainer = dynamic(
  () => import("@/src/components/NeshanMapContainer"),
  { ssr: false }
);
interface Props {
  onClick: (lat: string, lng: string) => void;
  onFinish: VoidFunction;
}
function AddressFormMap({ onClick, onFinish }: Props) {
  const { watch } = useFormContext<AddressForm>();
  const { address } = watch();

  const handleMapClick = (lat: string, lng: string) => {

    onClick(lat, lng);
  };
  return (
    <div className="flex flex-col gap-8">
      <p className="text-h4">موقعیت مکانی آدرس را مشخص کنید</p>

      <div className="h-[400px] w-[300px] lg:h-[300px] lg:w-[600px] ">
        <NeshanMapContainer ShowSearch onLocationChange={handleMapClick} />
      </div>
      <Button
        intent="primary"
        disabled={!address}
        fullWidth
        onClick={() => {
          onFinish();
        }}
      >
        تایید و ادامه
      </Button>
    </div>
  );
}

export default AddressFormMap;
