import * as Yup from "yup";

const areaSchema = Yup.object().shape({
  label: Yup.string().defined(),
  value: Yup.string().defined(),

  lat: Yup.string().defined(),
  lng: Yup.string().defined(),
});
export const addressSchema = Yup.object().shape({
  title: Yup.string().required("لطفا نام آدرس را وارد نمایید "),
  address: Yup.string().required("لطفا آدرس خود را وارد نمایید "),
  phone: Yup.string()
    .matches(
      /^(098|0098|98|\+98|0)?9(0[0-5]|[1 3]\d|2[0-3]|9[0-9]|41)\d{7}$/g,
      "لطفا شماره موبایل خود را بصورت درست وارد کنید "
    )
    .required("لطفا شماره موبایل خود را بصورت درست وارد کنید "),
  area: Yup.object().shape({
    parent: areaSchema.defined(),
    child: areaSchema.nullable(),
  }),

  lat: Yup.string(),
  lng: Yup.string(),
});
