import Button from "@/src/components/Button";
import NextImg from "@/src/components/NextImage";
import { Order } from "@/src/types/Cart";
import {
  convertLocalOrderStatusToPersian,
  numberWithCommas,
} from "@/src/utils/Helpers";
import { Money } from "iconsax-react";
import React from "react";

interface Props {
  item: Order;
  onCLick: VoidFunction;
  onPay?: VoidFunction;
  onComment: VoidFunction;
}
function OrderCard({ item, onCLick, onPay, onComment }: Props) {
  return (
    <div className="flex flex-col gap-8 border-b border-black/20 py-12 text-h4 ">
      <div className="flex items-center justify-between ">
        <p>شماره سفارش : {item.id}</p>
        <p> {item.date}</p>
        <p>
          وضعیت سفارش : {convertLocalOrderStatusToPersian(item.status ?? "")}
        </p>
      </div>
      <div className="flex items-center gap-4">
        {item.cart.map((cart) => (
          <div className="relative size-30" key={cart.variety.varietyID}>
            <NextImg
              imgWrapperClassName="rounded-base overflow-hidden"
              alt={cart.food.title}
              key={cart.food.chefID}
              width={64}
              height={64}
              src={cart.variety.image ?? ""}
            />
            {cart.count !== 1 && (
              <span className="absolute -bottom-5 flex size-10 items-center justify-center rounded-base border border-black/20 bg-white">
                {cart.count}
              </span>
            )}
          </div>
        ))}
      </div>
      <div className="flex flex-col">
        مبلغ :<span>{numberWithCommas(item.pricing.total)} تومان</span>
      </div>
      <hr />
      <div className="flex items-center justify-between ">
        <div>
          {item.status === "wating_payment" && onPay && (
            <button
              onClick={onPay}
              className="flex items-center gap-4 text-info"
            >
              <Money size="16" />
              پرداخت
            </button>
          )}
        </div>
        <div className="flex items-center gap-4">
          <Button onClick={onCLick} className="px-12" intent="outline">
            جزئیات سفارش
          </Button>
          {item.status === "delivered" && !item.hasComment && (
            <Button className="hidden px-12 lg:block" onClick={onComment}>
              ثبت نظر
            </Button>
          )}
        </div>
      </div>
    </div>
  );
}

export default OrderCard;
