import { OrderItems } from "@/src/types/general";
import React, { useCallback } from "react";

import { useUserOrdersQuery } from "@/src/hooks/Queries";
import CurrentOrders from "./CurrentOrders";

interface Props {
  activeTab: OrderItems;
}
function OrderTabs({ activeTab }: Props) {
  const { data, isLoading, refetch } = useUserOrdersQuery(activeTab);
  const ActiveTab = useCallback(() => {
    switch (activeTab) {
      case "current":
        return (
          <CurrentOrders
            onComment={refetch}
            isLoading={isLoading}
            orders={data ?? []}
          />
        );
      case "delivered":
        return (
          <CurrentOrders
            onComment={refetch}
            isLoading={isLoading}
            orders={data ?? []}
          />
        );
      case "wating_payment":
        return (
          <CurrentOrders
            onComment={refetch}
            isLoading={isLoading}
            orders={data ?? []}
          />
        );

      default:
        return (
          <CurrentOrders
            onComment={refetch}
            isLoading={isLoading}
            orders={data ?? []}
          />
        );
    }
  }, [activeTab, data]);
  return (
    <div className="flex w-full xl:p-8">
      <ActiveTab />
    </div>
  );
}

export default OrderTabs;
