import React from "react";
import { useTicketDetailQuery } from "@/src/hooks/Queries";
import { convertLocalTicketStatusToPersian } from "@/src/utils/Helpers";
import LoaderSpinner from "@/src/components/LoaderSpinner";
import Link from "next/link";
import moment from "jalali-moment";
import { ArrowRight } from "iconsax-react";
import TicketForm from "../TicketForm";

interface Props {
  ticketId: string;
  onBack: VoidFunction;
}
function TicketDetail({ ticketId, onBack }: Props) {
  const { data, isLoading, refetch } = useTicketDetailQuery(ticketId);
  return (
    <div className="flex flex-col gap-8 py-8">
      {isLoading && <LoaderSpinner />}
      {data && (
        <>
          <div className="flex w-full justify-between border-b border-black/20  pb-8">
            <div className="flex items-center gap-4">
              <button onClick={onBack}>
                <ArrowRight />
              </button>
              <p className="text-h3  ">
                {data.parent.title} - {data.parent.categoryTitle}
              </p>
            </div>
          </div>
          <div>
            <p className="text-h5">جزئیات تیکت</p>
            <table className="w-full border border-black/20 text-h5 font-normal">
              <thead>
                <tr className="border border-black/20  ">
                  <td className="rounded-base  border border-black/20 p-8">
                    عنوان: {data?.parent.title}
                  </td>
                  <td className="rounded-base  border border-black/20 p-8">
                    وضعیت:{" "}
                    {convertLocalTicketStatusToPersian(data?.parent.status)}
                  </td>
                </tr>
              </thead>
            </table>
          </div>
          <div key={data.parent.id}>
            <div className="flex items-center justify-between">
              <p className="text-h5">{data.parent.user} </p>
              <p className="text-h5">
                {" "}
                {moment(data.parent.date)
                  .locale("fa")
                  .format("YYYY/MM/DD - HH:mm")}
              </p>
            </div>
            <div className=" flex flex-col gap-4 rounded-base border border-black/20  p-8 text-h5">
              <span
                dangerouslySetInnerHTML={{
                  __html: data.parent.description,
                }}
              />

              {data.parent.file && (
                <Link
                  className="text-text-link"
                  href={data.parent.file ?? "/"}
                  target="_blank"
                >
                  مشاهده فایل
                </Link>
              )}
            </div>
          </div>
          {data.child.map((item) => (
            <div key={item.id}>
              <div className="flex items-center justify-between">
                <p className="text-h5">{item.user} </p>
                <p className="text-h5">
                  {moment(item.date).locale("fa").format("YYYY/MM/DD - HH:mm")}
                </p>
              </div>
              <div className="flex flex-col gap-4 rounded-base border border-black/20  p-8 text-h5">
                <span
                  dangerouslySetInnerHTML={{
                    __html: item.description,
                  }}
                />
                <br />
                {item.file && (
                  <Link
                    className="text-text-link"
                    href={item.file ?? "/"}
                    target="_blank"
                  >
                    مشاهده فایل
                  </Link>
                )}
              </div>
            </div>
          ))}

          <div className="static bottom-0">
            <TicketForm
              parentData={data.parent}
              onAddTicket={() => {
                refetch();
              }}
            />
          </div>
        </>
      )}
    </div>
  );
}

export default TicketDetail;
