import { ChefAvailableTimeList, ChefDetail } from "@/src/types/Chef";
import { ArrowDown2, Clock, Location } from "iconsax-react";
import React, { useState } from "react";

interface Props {
  data?: ChefAvailableTimeList;
  chefData: ChefDetail;
}
function SingleRestaurantTimes({ data, chefData }: Props) {
  const [menuCollapse, setMenuCollapse] = useState(true);
  return (
    <div className="absolute inset-x-4 top-4 z-40 flex flex-col gap-12  rounded-half border border-gray-100 bg-white px-4 py-8 text-h3 lg:right-8 lg:top-8  lg:w-full lg:max-w-sm lg:px-8  lg:py-12 ">
      <div className="flex w-full  items-center gap-4  ">
        <Location variant="Bold" className="text-primary" size="32" />
        <p>{chefData.address}</p>
      </div>

      <div>
        <button
          className="flex w-max items-center gap-4  "
          onClick={() => setMenuCollapse(!menuCollapse)}
        >
          <Clock variant="Bold" className="text-primary" size="20" />
          ساعت کاری
          <ArrowDown2
            size="20"
            className={`  text-primary duration-700 ${menuCollapse && "rotate-180"}`}
          />
        </button>
        <div
          className={`flex flex-col gap-8 overflow-auto border-r border-black/20 px-8 transition-max-height duration-700 ease-in-out ${
            menuCollapse ? "max-h-[600px]  " : "max-h-0"
          }`}
        >
          {data?.saturday?.title && (
            <div className="flex flex-col gap-6 ">
              <p>{data?.saturday?.title} :</p>
              {data.saturday.time.map((item, index) => (
                <p key={index}>
                  {item?.from} الی {item?.to}
                </p>
              ))}
            </div>
          )}
          {data?.sunday?.title && (
            <div className="flex flex-col gap-6 ">
              <p>{data?.sunday?.title} :</p>
              {data.sunday.time.map((item, index) => (
                <p key={index}>
                  {item?.from} الی {item?.to}
                </p>
              ))}
            </div>
          )}
          {data?.monday?.title && (
            <div className="flex flex-col gap-6 ">
              <p>{data?.monday?.title} :</p>
              {data.monday.time.map((item, index) => (
                <p key={index}>
                  {item?.from} الی {item?.to}
                </p>
              ))}
            </div>
          )}
          {data?.tuesday?.title && (
            <div className="flex flex-col gap-6 ">
              <p>{data?.tuesday?.title} :</p>
              {data.tuesday.time.map((item, index) => (
                <p key={index}>
                  {item?.from} الی {item?.to}
                </p>
              ))}
            </div>
          )}
          {data?.wednesday?.title && (
            <div className="flex flex-col gap-6 ">
              <p>{data?.wednesday?.title} :</p>
              {data.wednesday.time.map((item, index) => (
                <p key={index}>
                  {item?.from} الی {item?.to}
                </p>
              ))}
            </div>
          )}
          {data?.thursday?.title && (
            <div className="flex flex-col gap-6 ">
              <p>{data?.thursday?.title} :</p>
              {data.thursday.time.map((item, index) => (
                <p key={index}>
                  {item?.from} الی {item?.to}
                </p>
              ))}
            </div>
          )}
          {data?.friday?.title && (
            <div className="flex flex-col gap-6 ">
              <p>{data?.friday?.title} :</p>
              {data.friday.time.map((item, index) => (
                <p key={index}>
                  {item?.from} الی {item?.to}
                </p>
              ))}
            </div>
          )}
        </div>
      </div>
    </div>
  );
}

export default SingleRestaurantTimes;
