"use client";
import { useSelectionStore } from "@/src/store/useSelectionStore";
import { useEffect } from "react";

export function useRestaurantSelection(restaurantId?: string) {
  const ensure = useSelectionStore((s) => s.ensureRestaurant);
  const sel = useSelectionStore((s) =>
    restaurantId ? s.selections[restaurantId] : undefined
  );
  const update = useSelectionStore((s) => s.updateSelection);

  useEffect(() => {
    if (restaurantId) ensure(restaurantId);
  }, [restaurantId, ensure]);

  return {
    selection: sel,
    deliveryTime: sel?.deliveryTime,
    selectedAddressId: sel?.selectedAddressId,
    selectedDeliveryId: sel?.deliveryId,

    setDeliveryTime: (dt: {
      day: string;
      time: string;
      currentTime?: boolean;
    }) => restaurantId && update(restaurantId, { deliveryTime: dt }),

    setSelectedAddressId: (id: string) =>
      restaurantId && update(restaurantId, { selectedAddressId: id }),

    setSelectedDeliveryId: (id: string) =>
      restaurantId && update(restaurantId, { deliveryId: id }),
  };
}
