import { useEffect, useState } from "react";

const useScrollspy = (sectionIds: string[], offset: number = 0) => {
  const [activeMenu, setActiveMenu] = useState<string>("");

  useEffect(() => {
    const handleScroll = () => {
      const scrollPosition = window.scrollY + offset;

      // Find the section that is currently in view
      const activeSection = sectionIds.find((id) => {
        const section = document.getElementById(id);
        if (!section) return false;

        const { top, bottom } = section.getBoundingClientRect();
        const sectionTop = top + window.scrollY;
        const sectionBottom = bottom + window.scrollY + 100;

        return scrollPosition >= sectionTop && scrollPosition <= sectionBottom;
      });

      setActiveMenu(activeSection || ""); // Set active section, or empty if none
    };

    // Add event listener for scroll
    window.addEventListener("scroll", handleScroll);

    // Run on mount to initialize the active menu
    handleScroll();

    // Cleanup event listener on unmount
    return () => window.removeEventListener("scroll", handleScroll);
  }, [sectionIds, offset]);

  return activeMenu;
};

export default useScrollspy;
