import { useQuery } from "@tanstack/react-query";
import { useAddress } from "../UseAddress";

function UseAddressByIdQuery(id?: string) {
  const { getUserAddressById } = useAddress();

  const queryData = useQuery({
    queryKey: ["userAddress", id],
    queryFn: () => getUserAddressById(id ?? ""),
    enabled: !!id,
  });

  return queryData;
}

export default UseAddressByIdQuery;
