import { useQuery } from "@tanstack/react-query";
import { useFood } from "../UseFood";

interface Props {
  chefID: string;
  title?: string;
  time?: string;
  day?: string;
}
function UseCategoriesFoodsQuery({ chefID, title, day, time }: Props) {
  const { getChefCategoriesFoods } = useFood();

  const queryData = useQuery({
    queryKey: ["getCategoriesFoods", title, chefID, day, time],
    queryFn: () => getChefCategoriesFoods(chefID, title, day, time),
    refetchOnWindowFocus: false,
  });

  return queryData;
}

export default UseCategoriesFoodsQuery;
