import { useQuery } from "@tanstack/react-query";

import { useCategories } from "../UseCategories";

interface Props {
  chefID?: string;
  parentID?: string;
  lat?: string
  lng?: string
}
function UseCategoriesQuery({ chefID, parentID, lat, lng }: Props) {
  const { getCategories } = useCategories();

  const queryData = useQuery({
    queryKey: ["categoriesList", chefID, parentID, lat, lng],
    queryFn: () => getCategories(chefID, parentID, lat, lng),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseCategoriesQuery;
