import { useQuery } from "@tanstack/react-query";
import { useChefs } from "../UseChefs";

function UseChefAvailableQuery(chefID: string) {
  const { getChefAvailableNow } = useChefs();

  const queryData = useQuery({
    queryKey: ["ChefAvailable", chefID],
    queryFn: () => getChefAvailableNow(chefID),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseChefAvailableQuery;
