import { useQuery } from "@tanstack/react-query";
import { useChefs } from "../UseChefs";

function UseChefPopupAlarmsQuery(chefID: string) {
  const { getPopupAlarms } = useChefs();

  const queryData = useQuery({
    queryKey: ["ChefPopupAlarms", chefID],
    queryFn: () => getPopupAlarms(chefID),
    enabled: !!chefID,
  });

  return queryData;
}

export default UseChefPopupAlarmsQuery;
