import { keepPreviousData, useQuery } from "@tanstack/react-query";
import { FOODS_LIST_PAGINATED_QUERY_KEY } from "@/src/constants/QueryKeys";

import { useFood } from "../UseFood";

interface Props {
  code: string;
}
function UseCodeFoodsQuery({ code }: Props) {
  const { getFoodsWithCode } = useFood();

  const queryData = useQuery({
    queryKey: [FOODS_LIST_PAGINATED_QUERY_KEY, code],
    queryFn: () => getFoodsWithCode(code),
    placeholderData: keepPreviousData,
    refetchOnWindowFocus: false,
  });

  return queryData;
}

export default UseCodeFoodsQuery;
