import { useQuery, useQueryClient } from "@tanstack/react-query";
import { useAddress } from "../UseAddress";
import { Address } from "@/src/types/Address";
import { useCartStore } from "@/src/store";

type Params = {
  branch_id: number;
  delivery_type_id: number;
  user_id?: number;
  lat?: string;
  lng?: string;
};

export type AdrressProp = {
  value: string;
  description: string;
  label: string;
  isActive: boolean;
};

function UseOrderAddressByParamQuery() {
  const { getUserOrderAddressByParam } = useAddress();
  const queryClient = useQueryClient();
  const queryKey = ["userOrderAddressListParam"];

  const query = useQuery<AdrressProp[], Error>({
    queryKey,
    queryFn: () => Promise.resolve([]), // no fetch on mount
    enabled: false,
    staleTime: 0,
  });

  const refetchWithParamsOrderAreaAddress = async (params: Params) => {
    const result = await getUserOrderAddressByParam(params);
    // Transform if needed (you already have a typed return)
    const mappedResult: AdrressProp[] = result.modeledData.map((item: any) => ({
      value: item.value,
      description: item.description,
      label: item.label,
      isActive: item.isActive ?? false,
    }));

    queryClient.setQueryData(queryKey, mappedResult);
    useCartStore.getState().setAddressOrder(mappedResult);

    return {
      mappedResult,
      isLocationInActiveArea: result.isLocationInActiveArea,
    };
  };

  return {
    ...query, // includes data, isLoading, error, etc.
    refetchWithParamsOrderAreaAddress,
  };
}

export default UseOrderAddressByParamQuery;
