import { keepPreviousData, useQuery } from "@tanstack/react-query";
import { orderData } from "@/src/types/general";
import { FOODS_LIST_PAGINATED_QUERY_KEY } from "@/src/constants/QueryKeys";
import { Location } from "@/src/types/map";
import { useFood } from "../UseFood";

interface Props {
  order: orderData;
  categoryID?: string;
  page?: number;
  chefID?: string;
  hasDiscount?: boolean;
  title?: string;
  description?: string;
  location?: Location;
  prePage?: number;
}
function UsePaginatedFoodsQuery({
  order,
  categoryID,
  page = 1,
  chefID,
  hasDiscount,
  title,
  description,
  location,
  prePage,
}: Props) {
  const { getPaginatedFoods } = useFood();

  const queryData = useQuery({
    queryKey: [
      FOODS_LIST_PAGINATED_QUERY_KEY,
      order,
      categoryID,
      page,
      title,
      description,
      hasDiscount,
      chefID,
      prePage,
    ],
    queryFn: () =>
      getPaginatedFoods({
        order,
        categoryID,
        page,
        chefID,
        hasDiscount,
        title,
        description,
        location,
        prePage,
      }),
    placeholderData: keepPreviousData,
    refetchOnWindowFocus: false,
  });

  return queryData;
}

export default UsePaginatedFoodsQuery;
