import { keepPreviousData, useQuery } from "@tanstack/react-query";
import { useTicket } from "../UseTicket";

interface Props {
  page?: number;
}
function UsePaginatedTicketQuery({ page = 1 }: Props) {
  const { userTickets } = useTicket();

  const queryData = useQuery({
    queryKey: ["userTicket", page],
    queryFn: () => userTickets(page),
    placeholderData: keepPreviousData,
    refetchOnWindowFocus: false,
    staleTime: 1000,
  });

  return queryData;
}

export default UsePaginatedTicketQuery;
