import { useQuery } from "@tanstack/react-query";
import { useComments } from "../UseComments";

function UseProductCommentQuery(chefID: string) {
  const { getFoodComments } = useComments();

  const queryData = useQuery({
    queryKey: ["commentsList", chefID],
    queryFn: () => getFoodComments(chefID),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseProductCommentQuery;
