import { useQuery } from "@tanstack/react-query";
import { SliderType } from "@/src/services/httpServices/SettingsServices/types";
import { useSettings } from "../UseSettings";

function UseSliderQuery(type: SliderType) {
  const { getSlider } = useSettings();

  const queryData = useQuery({
    queryKey: ["sliders", type],
    queryFn: () => getSlider(type),
    staleTime: Infinity,
  });

  return queryData;
}

export default UseSliderQuery;
