import { keepPreviousData, useQuery } from "@tanstack/react-query";
import { useTransactions } from "../UseTransactions";

interface Props {
  page?: number;
}

function UseTransactionsQuery({ page }: Props) {
  const { userTransactions } = useTransactions();

  const queryKey = ["UserTransactions", page];
  const queryData = useQuery({
    queryKey,
    placeholderData: keepPreviousData,
    queryFn: () => userTransactions(page),
    refetchOnWindowFocus: false,
  });

  return queryData;
}

export default UseTransactionsQuery;
