import { useQuery } from "@tanstack/react-query";

import { OrderItems } from "@/src/types/general";
import { useCart } from "../UseCart";

function UseOrderQuery(type: OrderItems) {
  const { getUserOrders } = useCart();

  const queryKey = ["userOrders", type];
  const queryData = useQuery({
    queryKey,
    queryFn: () => getUserOrders(type),
    refetchOnWindowFocus: false,
  });

  return queryData;
}

export default UseOrderQuery;
