import { ApiBranch } from "@/src/services/httpServices/ChefService/types";
import {
  getHomePageSliderService,
  getPageComponentDataByCodeService,
  getSiteLogoService,
} from "@/src/services/httpServices/SettingsServices";
import { SliderType } from "@/src/services/httpServices/SettingsServices/types";
import { BaseChef } from "@/src/types/Chef";

import { useState } from "react";

function UseSettings() {
  const [isLoading, setIsLoading] = useState(false);

  const getSlider = async (type: SliderType) => {
    try {
      setIsLoading(true);

      let lat: string | undefined;
      let lng: string | undefined;

      if (typeof window !== "undefined") {
        const unsavedAddress = localStorage.getItem("unsavedAddress");
        if (unsavedAddress) {
          try {
            const addressData = JSON.parse(unsavedAddress);
            lat = addressData?.lat;
            lng = addressData?.lng;
          } catch (error) {
            console.error("Error parsing unsavedAddress:", error);
          }
        }
      }

      const queryParams = new URLSearchParams({
        ...(lat ? { lat } : {}),
        ...(lng ? { lng } : {}),
      }).toString();

      const result = await getHomePageSliderService(type, queryParams);

      const modeledUser = result.map((item) => ({
        id: item.product?.id,
        image: item.image,
        title: item.product?.title,
        link: item?.link ?? "",
      }));

      return modeledUser;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getLogo = async () => {
    try {
      setIsLoading(true);
      const result = await getSiteLogoService();
      return {
        logo: result,
      };
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };
  const getHomeSellers = async (code: string) => {
    try {
      setIsLoading(true);
      let lat: string | undefined;
      let lng: string | undefined;

      try {
        const unsavedAddress = localStorage.getItem("unsavedAddress");
        if (unsavedAddress) {
          const addressData = JSON.parse(unsavedAddress);
          lat = addressData?.lat;
          lng = addressData?.lng;
        }
      } catch (error) {
        console.error("Error parsing unsavedAddress:", error);
      }

      const result = await getPageComponentDataByCodeService<ApiBranch[]>(code,
        {
          ...(lat ? { lat } : {}),
          ...(lng ? { lng } : {})
        }

      );

      const data: BaseChef[] = result.map((chef) => ({
        id: chef.id,
        title: chef.title,
        logo: chef.logo,
        cover: chef.cover,
        ariaTitle: chef?.area?.title ?? "",
        rate: +chef.rate,
        FoodsCounts: chef.products_count,
        avgPrice: chef?.products_with_variety_avg_price ?? 0,
      }));
      return data;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  return {
    isLoading,
    getSlider,
    getLogo,
    getHomeSellers,
  };
}

export default UseSettings;
