import { getUserTransactionService } from "@/src/services/httpServices/TransactionServices";
import { Transaction } from "@/src/types/Transactions";
import { PaginationResult } from "@/src/types/general";
import { convertApiTransactionStatusToLocal } from "@/src/utils/Helpers";
import { useState } from "react";

function UseTransactions() {
  const [isLoading, setIsLoading] = useState(false);

  const userTransactions = async (page: number = 1) => {
    try {
      setIsLoading(true);
      const res = await getUserTransactionService({
        page,
        paginate: 10,
      });
      const result: PaginationResult<Transaction> = {
        currentPage: res.current_page,
        perPage: res.per_page,
        total: res.total,
        totalPages: res.last_page,
        data: res.data.map((item) => ({
          amount: item.amount,
          date: item.created_at,
          description: item.description,
          transaction_type: convertApiTransactionStatusToLocal(
            item.transaction_type
          ),
          id: item.id,
        })),
      };
      return result;
    } catch (error) {
      console.log(error);
      throw error;
    } finally {
      setIsLoading(false);
    }
  };

  return {
    isLoading,
    userTransactions,
  };
}

export default UseTransactions;
