"use client";

import { ReactNode, useMemo } from "react";
import { useAuth } from "../hooks";

interface Props {
  children: ReactNode;
}
function AuthProvider({ children }: Props) {
  const { getUser, getTokenFromCookies } = useAuth();
  useMemo(() => {
    const token = getTokenFromCookies();
    if (token) {
      getUser();
    }
  }, []);
  return children;
}

export default AuthProvider;
