"use client";

import React, {
  type ReactNode,
  createContext,
  useRef,
  useContext,
} from "react";
import { useStore } from "zustand";

import { SettingsStore } from "../types/general";
import { createSettingsStore } from "../store";
import { ApiSettings } from "../services/httpServices/SettingsServices/types";

export type SettingsStoreApi = ReturnType<typeof createSettingsStore>;

export const SettingsStoreContext = createContext<SettingsStoreApi | undefined>(
  undefined
);

export interface CounterStoreProviderProps {
  children: ReactNode;
  settings: ApiSettings;
}

function SettingsProvider({ children, settings }: CounterStoreProviderProps) {
  const storeRef = useRef<SettingsStoreApi>();
  if (!storeRef.current) {
    storeRef.current = createSettingsStore({
      eata: settings.eata,
      enamadCode: settings.enamadCode,
      instagram: settings.instagram,
      logo: settings.logo,
      scripts: settings.scripts,
      headerTelephoneSupport: settings.headerTelephoneSupport,
      sorosh: settings.sorosh,
      headerTextSupport: settings.headerTextSupport,
      telegram: settings.telegram,
      whatsapp: settings.whatsapp,
      mode: settings.systemMode,
      singleModeBranch: settings.branchSingleModeId,
      smDescription: settings.smDescription,
      title: settings.title,
      forceMap: settings.mapAddress === "show",
      privacyRoute: settings?.linkRule ?? "#",
      authBg: settings.backgroundPage,
      loader: settings.loader,
      emptyProductImage: settings.emptyProductImage,
    });
  }

  return (
    <SettingsStoreContext.Provider value={storeRef.current}>
      {children}
    </SettingsStoreContext.Provider>
  );
}

export const useSettingsStore = <T,>(
  selector: (store: SettingsStore) => T
): T => {
  const counterStoreContext = useContext(SettingsStoreContext);

  if (!counterStoreContext) {
    throw new Error(`useSettingsStore must be used within SettingsProvider`);
  }

  return useStore(counterStoreContext, selector);
};
export default SettingsProvider;
