import { apiEndpoints } from "@/src/constants/Endpoints";
import { httpService } from "../httpService";
import {
  ApiAddress,
  ApiAddressByTime,
  ApiArea,
  ApiCreateAddress,
} from "./types";

const { address, cart, area } = apiEndpoints;

export const createAddressService = (data: ApiCreateAddress) =>
  httpService.post(address.create, data);
export const updateAddressService = (id: string, data: ApiCreateAddress) =>
  httpService.put(`${address.update}/${id}`, data);
export const getUserAddressService = (params?: {
  address_title?: string;
  address_area?: string;
}): Promise<ApiAddress[]> => {
  return httpService.get(address.getUserAddress, { params });
};
export const getUserOrderAddressService = (): Promise<ApiAddress[]> =>
  httpService.get(cart.getAddress);
export const getAddressesForDeliveryTypeService = (
  queryParams: Record<string, string>
): Promise<ApiAddressByTime> => {
  const queryString = new URLSearchParams(queryParams).toString();
  return httpService.get(
    `${area.userAddressesForDeliveryType}?${queryString}`,
    undefined,
    false
  );
};

export const getUserAddressByIdService = (id: string): Promise<ApiAddress> =>
  httpService.get(`${address.base}${id}`);
export const deleteUserAddressByIdService = (id: string) =>
  httpService.delete(`${address.delete}`, {
    data: {
      id,
    },
  });

export const getAreasService = (parentId = "0"): Promise<ApiArea[]> =>
  httpService.get(area.base, {
    params: {
      parent_id: parentId,
    },
  });
