import { apiEndpoints } from "@/src/constants/Endpoints";
import {
  ApiBaseUser,
  ApiChargeWallet,
  ApiChargeWalletResult,
  ApiCheckCode,
  ApiCheckCodeResult,
  ApiSendCode,
} from "./types";
import { httpService } from "../httpService";

const {
  user: { getProfile, updateProfile, changeAddress, getWallet, ChargeWallet },
  auth: { sendCode, checkCode },
} = apiEndpoints;

const sendCodeService = (data: ApiSendCode) => httpService.post(sendCode, data);
const checkCodeService = (data: ApiCheckCode): Promise<ApiCheckCodeResult> =>
  httpService.post(checkCode, data);
const getUserProfileService = (): Promise<ApiBaseUser> =>
  httpService.get(getProfile);
const updateProfileService = (data: ApiBaseUser) =>
  httpService.put(updateProfile, data);
const updateSelectedAddress = (data: { id: number }) =>
  httpService.put(`${changeAddress}${data.id}`);

const getUserWalletService = (): Promise<number> => httpService.get(getWallet);
const ChargeUserWalletService = (
  data: ApiChargeWallet
): Promise<ApiChargeWalletResult> => httpService.post(ChargeWallet, data);

export {
  sendCodeService,
  checkCodeService,
  getUserProfileService,
  updateProfileService,
  updateSelectedAddress,
  getUserWalletService,
  ChargeUserWalletService,
};
