import { defaultAddressItemProp } from "@/src/types/auth";
import { ApiTimeStampData } from "@/src/types/general";

export interface ApiSendCode {
  mobile: string;
}
export interface ApiCheckCode {
  mobile: string;
  code: string;
}

export interface ApiBaseUser extends ApiTimeStampData {
  default_address?: defaultAddressItemProp;
  id?: number;
  name: string;
  family: string;
  mobile?: string;
  username?: string;
  password?: string;
  default_address_id?:string  
  tel?: string;
  email?: string;
  birth_date?: string;
  day?: number;
  month?: number;
  year?: number;
  referral_code?: string;
  wallet_balance?: number;
}
export interface ApiCheckCodeResult {
  token: string;
  user: ApiBaseUser;
}
export interface ApiChargeWallet {
  amount: number;
}
export interface ApiChargeWalletResult extends ApiTimeStampData {
  amount: string;
  user_id: string;
  code_pay: string;
}
