import { ApiTimeStampData, OrderItems } from "@/src/types/general";
import { ApiBranch } from "../../ChefService/types";
import { ApiVariety } from "../../FoodServices/types";
import { ApiAddress } from "../../AddressServices/types";
import { ApiBaseUser } from "../../AuthServices/types";
import { ApiComment } from "../../CommentService/types";

export interface ApiAddCart {
  variety_id: string;
  count: number;
  extraIds?: string;
  time?: string;
  week_day?: string;
  address_id: string | null;
  delivery_type_id: string | null;
}
export interface ApiRemoveCart {
  variety_id: string;
  count: number;
  extraIds?: string;
}
export interface ApiUpdateCart {
  carts: ApiAddCart[];
  week_day?: string;
  time?: string;
}
export interface ApiCheckDiscount {
  coupon: string;
}
export interface ApiCartVariety extends ApiVariety {
  product: {
    id: string;
    title: string;
    image?: string;
  };
}

export interface OrderCart extends ApiTimeStampData {
  id: string;
  order_id: number;
  variety: ApiCartVariety;
  count: number;
  price: string;
  discount: string;
  varietie: string | null;
  extra_ids: string | null;
  extras: string | null;
}
export interface Price {
  sumProduct: number;
  sumExtras: number;
  sumPaking: number;
  priceShippingOrder: number | null;
  sumTotal: number;
  sumTax: string;
  cashBack: number;
  totalPayment: number;
}
export interface ApiDeliveryTypes extends ApiTimeStampData {
  id: string;
  title: string;
  is_cost: boolean;
  is_address: boolean;
  description_text: string;
  description_required: boolean;
  description_error_text: string;
  is_active: boolean;
  message?: string;
}
export interface ApiOrder extends ApiTimeStampData {
  packing_price?: string | null;
  cash_back_price?: string | null;
  id: string;
  address_id: string | null;
  address: string | null;
  branch_id: string;
  driver_id: string | null;
  user_id: number;
  payment_code_gateway: string | null;
  payment_type: string | null;
  order_status: OrderItems | null;
  payment_status: string;
  payment_code: string | null;
  order_price: string | null;
  delivery_price: string | null;
  tax_price: string | null;
  discount_price: string | null;
  coupon_id: string | null;
  carts: OrderCart[];
  order_cart: OrderCart[];
  branch: ApiBranch;
  address_order?: ApiAddress;
  user?: ApiBaseUser;
  comment_user: ApiComment | null;
  delivery_type?: ApiDeliveryTypes;
}

export interface APICart {
  order: ApiOrder;
  price: Price;
  address?: {
    address: string;
    id: string;
    plaque: string;
    postal_code: string;
    title: string;
    unit: string;
    lat: string;
    lng: string;
  };
}
export interface ApiSetAddress {
  address_id?: string;
  branch_id?: string;
  lat?: string;
  lng?: string;
  // delivery_type_id?: string;
}

export interface ApiSetAddressByLocation {
  branch_id: string;
  day?: string;
  time?: string;
}

export interface ApiSetDelivery {
  delivery_type_id?: string;
  address_id: string | null;
}
export interface ApiDiscount {
  discountPrice: number;
}
export interface ApiGateways {
  id: string;
  title: string;
  status: boolean;
}

export interface ApiCartResult {
  guest_token: string;
}

export interface OrderAmount {
  orderAmount1: string;
  orderAmount2: string | null;
  orderAmountDelivery: string;
}

interface ServiceData {
  id: number;
  area_id: number;
  branch_id: number;
  day: string;
  service_time_from: string;
  service_time_to: string;
  min_order: number;
  delivery_time: number;
  order_limit_per_half_hour: number;
  free_delivery: boolean;
  free_delivery_min_amount: number | null;
  out_of_range_price: number;
  status: boolean;
  service_fee: number;
  order_amounts: {
    orderAmount1: string;
    orderAmount2: string | null;
    orderAmountDelivery: string;
  }[];
  shipping_methods: string[];
  created_at: string;
  updated_at: string;
}

interface Product {
  id: number;
  title: string;
  image: string;
}

interface Variety {
  id: number;
  product_id: number;
  title: string;
  min_description: string;
  description: string;
  price: string;
  price_paking: string;
  count: number;
  discount: string;
  order: string;
  max_order: number;
  created_at: string;
  updated_at: string;
  deleted_at: string | null;
  discounted_price: number;
  product: Product;
}

interface Branch {
  id: number;
  title: string;
  address: string;
  logo: string;
  min_order: string;
  vendor_id: number;
  lat: string;
  lng: string;
  cash_back_status: string;
  cash_back_percent: number;
  cash_back_max_price: number;
}

interface DeliveryType {
  id: number;
  title: string;
  is_address: boolean;
  description_text: string;
  description_required: boolean;
  description_error_text: string;
  is_active: boolean;
  message: string | null;
  created_at: string;
  updated_at: string;
  deleted_at: string | null;
  delivery_method: string | null;
}

interface OrderDetails {
  id: number;
  address_id: number | null;
  address: string | null;
  branch_id: number;
  driver_id: number | null;
  user_id: number;
  guest_token: string | null;
  code: string | null;
  payment_type: string | null;
  payment_status: string;
  payment_code: string | null;
  payment_code_gateway: string | null;
  order_price: string;
  wallet_use_price: number;
  delivery_type_id: number;
  delivery_price: string;
  cash_back_price: string;
  tax_price: string | null;
  discount_price: string | null;
  coupon_id: number | null;
  payment_getway_id: number | null;
  delivery_time: string;
  preparation_time: string | null;
  order_status: string;
  carts: unknown;
  description: string | null;
  created_at: string;
  updated_at: string;
  deleted_at: string | null;
  order_cart: OrderCart[];
  branch: Branch;
  address_order: unknown;
  delivery_type: DeliveryType;
}

interface OrderPrice {
  sumProduct: number;
  sumExtras: number;
  sumPaking: number;
  priceShippingOrder: number;
  sumTotal: number;
  totalPayment: number;
  cashBack: number;
  sumTax: string;
}

interface OrderData {
  guest_token: string | null;
  order: OrderDetails;
  price: OrderPrice;
}

export interface ServiceDetails {
  data: ServiceData;
  active: boolean;
  delivery_type: {
    id: string;
    title: string;
  };
  message: string;
  open_branch: boolean;
  address_valid: boolean;
  order: OrderData;
}
