import { apiEndpoints } from "@/src/constants/Endpoints";
import { ApiSitemap } from "@/src/types/general";
import { httpService } from "../httpService";
import {
  ApiCategoriesFood,
  ApiFoodCalories,
  ApiFoodParams,
  ApiProduct,
  ApiProductPaginated,
} from "./types";

const { product } = apiEndpoints;

export const getFoodsService = (
  params?: ApiFoodParams
): Promise<ApiProductPaginated> => httpService.get(product.base, { params });

export const getFoodService = (id: string): Promise<ApiProduct> =>
  httpService.get(`${product.getProduct}${id}`);
export const getChefCategoriesFoodsService = (
  chefID: string,
  title?: string,
  day?: string,
  time?: string
): Promise<ApiCategoriesFood[]> =>
  httpService.get(product.getProductCategoryWithBranch, {
    params: {
      branch_id: chefID,
      ...(title && {
        title,
      }),
      ...(day && {
        Week_day: day,
      }),
      ...(time && {
        time,
      }),
    },
  });
export const getFoodCaloriesService = (id: string): Promise<ApiFoodCalories> =>
  httpService.get(`${product.getCalories}/${id}`);
export const getFoodSitemapService = (): Promise<ApiSitemap> =>
  httpService.get(product.sitemap);
