import { create } from "zustand";
import { AuthUser } from "../types/auth";

const initialAuthUser: AuthUser = {
  id:"",
  name: "",
  family: "",
  mobile: "",
  email: "",
  phone: "",
  inviteCode: "",
  wallet_balance: 0,
};

interface AuthStore {
  authUser: AuthUser;
  setAuthUser: (user: AuthUser) => void;
  resetAuthUser: () => void;
}

const useAuthStore = create<AuthStore>()((set) => ({
  authUser: initialAuthUser,

  setAuthUser: (user: AuthUser) =>
    set((state) => ({
      authUser: {
        ...state.authUser,
        ...user,
      },
    })),

  resetAuthUser: () =>
    set(() => ({
      authUser: initialAuthUser,
    })),
}));

export default useAuthStore;
