import { BaseChef } from "./Chef";
import { Category } from "./category";
import { File, orderData } from "./general";
import { Location } from "./map";

export interface Discount {
  percent: number;
  discountedPrice: number;
}
export interface Variety {
  price: number;
  varietyID: string;
  title: string;
  maxOrderLimit?: number;
  quantity?: number;
  image?: string;
  discount: Discount;
}
export interface BaseFood {
  id: string;
  image: string;
  title: string;
  description?:string;
  Summary: string;
  rate: number;
  chefID: string;
  chefLogo?: string;
  calory?: number;
  varieties: Variety[];
}
export interface FoodParams {
  order: orderData;
  categoryID?: string;
  chefID?: string;
  page: number;
  hasDiscount?: boolean;
  title?: string;
  location?: Location;
  prePage?: number;
}
export interface Material {
  title: string;
  image: string;
  usage: string;
  unit: string;
}

export interface FoodDetail extends BaseFood {
  materials: Material[] | [];
  chef: BaseChef;
  description: string;
  gallery: File[];
}
export interface FoodMenu extends BaseFood {
  gallery: File[] | [];
}
export interface CategoriesFood extends Category {
  foods: FoodMenu[] | [];
}
export interface FoodSlider extends BaseFood {
  link: string;
  Chef: {
    id: string;
    title: string;
  };
}
