export interface BaseTicket {
  description: string;
  title: string;
  categoryId: string;
  file?: string;
}
export enum TicketStatusVariant {
  OPEN = "opened",
  CLOSED = "closed",
  WAITING = "waiting",
}
export type ticketStatusType =
  (typeof TicketStatusVariant)[keyof typeof TicketStatusVariant];

export interface TicketItem extends BaseTicket {
  status: ticketStatusType;
  categoryTitle: string;
  id: string;
  user?: string;
  date?: Date;
}
export interface TicketDetail {
  parent: TicketItem;
  child: TicketItem[];
}
