import { cookies } from "next/headers";
import { notFound, redirect } from "next/navigation";
import React from "react";
import OrderPage from "@/src/containers/Order";

function page({ searchParams }: { searchParams: { status: string } }) {
  const { status } = searchParams;
  if (!status) notFound();
  const cookieStore = cookies();
  const hasToken = !!cookieStore.get("token");
  if (!hasToken) {
    redirect("/auth");
  }
  return <OrderPage paymentResult={status === "200"} mode="wallet" />;
}

export default page;
