import "@/src/assets/globals.css";
import "swiper/css";
import "react-loading-skeleton/dist/skeleton.css";
import iranSans from "@/src/utils/fonts";
import React from "react";
import { Metadata } from "next";
import LayoutProvider from "../containers/Layouts";
import {
  AddressProvider,
  AuthProvider,
  CartProvider,
  QueryClientProvider,
  SettingsProvider,
  SkeletonProvider,
  SnackbarProvider,
  TranslationsProvider,
} from "../providers";

import ExternalScripts from "../components/ExternalScripts";
import { fetchData } from "./dataFetcher";

export async function generateMetadata(): Promise<Metadata> {
  const data = await fetchData();

  return {
    title: {
      template: `%s | ${data.settings.title} `,
      default: data.settings.title,
    },
    description: data.settings?.smDescription ?? "",
    keywords: data.settings?.keywords ?? "",
    openGraph: {
      title: data.settings?.title ?? "",
      description: data.settings?.smDescription ?? "",
    },
    icons: {
      icon: data.settings.faveIcon,
    },
    other: {
      "google-site-verification": data.settings["google-site-verification"],
    },
  };
}
export default async function RootLayout({
  children,
}: {
  children: React.ReactNode;
}) {
  const data = await fetchData();
  return (
    <html dir="rtl" lang="fa">
      <body className={`${iranSans.variable} bg-white font-iranSans `}>
        <TranslationsProvider>
          <QueryClientProvider>
            <AuthProvider>
              <SnackbarProvider>
                <SkeletonProvider>
                  <SettingsProvider settings={data.settings}>
                    <CartProvider>
                      <AddressProvider>
                        <LayoutProvider pages={data.pages}>
                          {children}
                          {data.settings.scripts && (
                            <ExternalScripts script={data.settings.scripts} />
                          )}
                        </LayoutProvider>
                      </AddressProvider>
                    </CartProvider>
                  </SettingsProvider>
                </SkeletonProvider>
              </SnackbarProvider>
            </AuthProvider>
          </QueryClientProvider>
        </TranslationsProvider>
      </body>
    </html>
  );
}
