import React from "react";
import { Metadata } from "next";
import dynamic from "next/dynamic";
import { fetchData } from "./dataFetcher";

export async function generateMetadata(): Promise<Metadata> {
  const { settings } = await fetchData();
  return {
    title: settings?.title ?? "",
    description: settings?.smDescription ?? "",
    keywords: settings?.keywords ?? "",
    openGraph: {
      title: settings?.title ?? "",
      description: settings?.smDescription ?? "",
    },
  };
}
const SingleRestaurant = dynamic(
  () => import("../containers/SingleRestaurant")
);
const HomePage = dynamic(() => import("../containers/HomePage"));

async function page() {
  const { settings } = await fetchData();
  if (settings.systemMode === "single")
    return <SingleRestaurant id={settings.branchSingleModeId ?? "1"} />;
  return <HomePage />;
}

export default page;
